/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.impl.effect;

import com.eeeab.eeeabsmobs.client.util.ControlledAnimation;
import com.eeeab.eeeabsmobs.sever.entity.impl.effect.EntityMagicEffects;
import com.eeeab.eeeabsmobs.sever.entity.impl.namelessguardian.EntityNamelessGuardian;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityGuardianBlade
extends EntityMagicEffects {
    public final ControlledAnimation alphaControlled = new ControlledAnimation(20);
    private static final float MAX_DAMAGE = 30.0f;
    private static final int PLAY_DURATION = 32;
    private static final int GUARDIAN_DURATION = 40;
    private boolean moveOffset;
    private int aliveTick;
    private static final float[][] BLOCK_OFFSETS = new float[][]{{-0.5f, -0.5f}, {-0.5f, 0.5f}, {0.5f, 0.5f}, {0.5f, -0.5f}};

    public EntityGuardianBlade(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public EntityGuardianBlade(Level level, LivingEntity caster, double x, double y, double z, float yRot, boolean moveOffset) {
        this((EntityType)EntityInit.GUARDIAN_BLADE.get(), level);
        this.moveOffset = moveOffset;
        this.caster = caster;
        this.m_146922_(yRot * 57.295776f - 90.0f);
        this.m_6034_(x, y, z);
    }

    @Override
    public void m_8119_() {
        int duration;
        super.m_8119_();
        this.alphaControlled.updatePrevTimer();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        int n = duration = this.caster instanceof EntityNamelessGuardian ? 40 : 32;
        if (this.aliveTick == 0) {
            Vec3 lookAngle = this.m_20154_();
            float speed = 1.4f;
            if (this.moveOffset) {
                speed += this.f_19796_.m_188501_() * 0.5f;
            }
            this.shoot(lookAngle.f_82479_, lookAngle.f_82480_, lookAngle.f_82481_, speed);
        } else if (this.aliveTick <= duration) {
            if (this.aliveTick % 5 == 0) {
                this.m_20256_(this.m_20184_().m_82542_(0.4, 0.4, 0.4));
                this.alphaControlled.increaseTimer(2);
            }
            this.breakBlockEffect();
            this.doHurtTarget();
        } else {
            this.alphaControlled.increaseTimer(2);
        }
        if (this.alphaControlled.getTimer() >= 20) {
            this.m_146870_();
        }
        ++this.aliveTick;
    }

    private void shoot(double x, double y, double z, double speed) {
        this.m_20334_(x * speed, y * speed, z * speed);
    }

    private void doHurtTarget() {
        if (!this.f_19853_.f_46443_ && this.caster != null) {
            double duration = this.caster instanceof EntityNamelessGuardian ? 40.0 : 32.0;
            double attackValue = this.caster.m_21133_(Attributes.f_22281_);
            attackValue = Mth.m_14008_((double)attackValue, (double)0.0, (double)30.0);
            List entities = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.2));
            for (LivingEntity target : entities) {
                if (target == this.caster) continue;
                if (this.caster instanceof EntityNamelessGuardian) {
                    attackValue += (double)(target.m_21233_() * 0.05f);
                }
                double damage = Math.abs(attackValue * (((double)this.aliveTick - duration) / duration));
                target.m_6469_(DamageSource.m_19367_((Entity)target, (Entity)this.caster), (float)damage);
            }
        }
    }

    private void breakBlockEffect() {
        if (this.f_19853_.f_46443_) {
            double theta = (double)this.m_146908_() * (Math.PI / 180);
            double perpX = Math.cos(theta);
            double perpZ = Math.sin(theta);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            double x = this.m_20185_() + 1.0 * vecX;
            double y = this.m_20191_().f_82289_ + 0.1;
            double z = this.m_20189_() + 1.0 * vecZ;
            int hitY = Mth.m_14107_((double)(this.m_20186_() - 0.2));
            for (float[] floats : BLOCK_OFFSETS) {
                int hitZ;
                float ox = floats[0];
                float oy = floats[1];
                int hitX = Mth.m_14107_((double)(x + (double)ox));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ = Mth.m_14107_((double)(z + (double)oy)));
                BlockState block = this.f_19853_.m_8055_(hit);
                if (block.m_60799_() == RenderShape.INVISIBLE) continue;
                int count = 14 - (int)((double)this.f_19797_ * 0.75);
                for (int n = 0; n < count; ++n) {
                    double pa = this.f_19796_.m_188500_() * 2.0 * Math.PI;
                    double pd = this.f_19796_.m_188500_() * 0.6 - 0.1;
                    double px = x + Math.cos(pa) * pd;
                    double pz = z + Math.sin(pa) * pd;
                    double magnitude = this.f_19796_.m_188500_() * 4.0 + 5.0;
                    double velX = perpX * magnitude;
                    double velY = this.f_19796_.m_188500_() * 3.0 + 6.0;
                    double velZ = perpZ * magnitude;
                    if (vecX * (pz - this.m_20189_()) - vecZ * (px - this.m_20185_()) > 0.0) {
                        velX = -velX;
                        velZ = -velZ;
                    }
                    this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), px, y, pz, velX, velY, velZ);
                }
            }
        }
    }
}

